/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.builders;

import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.AbstractBuilder;
import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.fabric.EnvExecutor;
import com.tterrag.registrate.fabric.RegistryObject;
import com.tterrag.registrate.mixin.accessor.BlockEntityRenderersAccessor;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_5614;
import net.minecraft.class_7924;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

public class BlockEntityBuilder<T extends class_2586, P>
extends AbstractBuilder<class_2591<?>, class_2591<T>, P, BlockEntityBuilder<T, P>> {
    private final BlockEntityFactory<T> factory;
    private final Set<NonNullSupplier<? extends class_2248>> validBlocks = new HashSet<NonNullSupplier<? extends class_2248>>();
    @Nullable
    private NonNullSupplier<NonNullFunction<class_5614.class_5615, class_827<? super T>>> renderer;

    public static <T extends class_2586, P> BlockEntityBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, BlockEntityFactory<T> factory) {
        return new BlockEntityBuilder<T, P>(owner, parent, name, callback, factory);
    }

    protected BlockEntityBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, BlockEntityFactory<T> factory) {
        super(owner, parent, name, callback, class_7924.field_41255);
        this.factory = factory;
    }

    public BlockEntityBuilder<T, P> validBlock(NonNullSupplier<? extends class_2248> block) {
        this.validBlocks.add(block);
        return this;
    }

    @SafeVarargs
    public final BlockEntityBuilder<T, P> validBlocks(NonNullSupplier<? extends class_2248> ... blocks) {
        Arrays.stream(blocks).forEach(this::validBlock);
        return this;
    }

    public BlockEntityBuilder<T, P> renderer(NonNullSupplier<NonNullFunction<class_5614.class_5615, class_827<? super T>>> renderer) {
        if (this.renderer == null) {
            EnvExecutor.runWhenOn(EnvType.CLIENT, () -> this::registerRenderer);
        }
        this.renderer = renderer;
        return this;
    }

    protected void registerRenderer() {
        this.onRegister(entry -> BlockEntityRenderersAccessor.invokeRegister(entry, ((NonNullFunction)this.renderer.get())::apply));
    }

    @Override
    protected class_2591<T> createEntry() {
        BlockEntityFactory factory = this.factory;
        NonNullSupplier supplier = this.asSupplier();
        return class_2591.class_2592.method_20528((pos, state) -> factory.create((class_2591)supplier.get(), pos, state), (class_2248[])((class_2248[])this.validBlocks.stream().map(Supplier::get).toArray(class_2248[]::new))).method_11034(null);
    }

    @Override
    protected RegistryEntry<class_2591<T>> createEntryWrapper(RegistryObject<class_2591<T>> delegate) {
        return new BlockEntityEntry<T>(this.getOwner(), delegate);
    }

    @Override
    public BlockEntityEntry<T> register() {
        return (BlockEntityEntry)super.register();
    }

    public static interface BlockEntityFactory<T extends class_2586> {
        public T create(class_2591<T> var1, class_2338 var2, class_2680 var3);
    }
}

